VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "DriverLinx Port I/O for ADC-16"
   ClientHeight    =   4035
   ClientLeft      =   3120
   ClientTop       =   3975
   ClientWidth     =   5895
   LinkTopic       =   "Form1"
   ScaleHeight     =   4035
   ScaleWidth      =   5895
   Begin VB.ListBox lstResults 
      Height          =   2400
      Left            =   2640
      TabIndex        =   13
      Top             =   480
      Width           =   1215
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Left            =   360
      Top             =   2760
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4200
      TabIndex        =   3
      Top             =   1560
      Width           =   1215
   End
   Begin VB.CommandButton cmdRead 
      Caption         =   "Start Readings"
      Height          =   495
      Left            =   4200
      TabIndex        =   2
      Top             =   840
      Width           =   1215
   End
   Begin VB.TextBox txtAddr 
      Height          =   285
      Left            =   960
      TabIndex        =   0
      Text            =   "768"
      Top             =   240
      Width           =   615
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H80000009&
      Height          =   255
      Left            =   240
      TabIndex        =   12
      Top             =   3360
      Width           =   3015
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 7"
      Height          =   255
      Index           =   7
      Left            =   1440
      TabIndex        =   11
      Top             =   2280
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 6"
      Height          =   255
      Index           =   6
      Left            =   1440
      TabIndex        =   10
      Top             =   1800
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 5"
      Height          =   255
      Index           =   5
      Left            =   1440
      TabIndex        =   9
      Top             =   1320
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 4"
      Height          =   255
      Index           =   4
      Left            =   1440
      TabIndex        =   8
      Top             =   840
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 3"
      Height          =   255
      Index           =   3
      Left            =   480
      TabIndex        =   7
      Top             =   2280
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 2"
      Height          =   255
      Index           =   2
      Left            =   480
      TabIndex        =   6
      Top             =   1800
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 1"
      Height          =   255
      Index           =   1
      Left            =   480
      TabIndex        =   5
      Top             =   1320
      Width           =   735
   End
   Begin VB.Label lblResult 
      BackColor       =   &H80000009&
      Caption         =   "Ch 0"
      Height          =   255
      Index           =   0
      Left            =   480
      TabIndex        =   4
      Top             =   840
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Base Addr"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim baseAddr As Integer
Dim i As Integer


Private Sub cmdExit_Click()
End
End Sub


Private Sub cmdRead_Click()
i = 0   ' set starting channel
Timer1.Enabled = True   'allow the timer to dictate when reading happen
lstResults.Clear    'clear the display..

End Sub

Public Sub Read_ADC16(ByVal chan As Integer)
Dim ready As Byte
Dim low As Integer
Dim high As Integer
Dim reading As Single
Dim j As Integer

Dim signbit As Boolean

DlPortWritePortUchar baseAddr + 3, 0       ' write control register to
                                           
                                           ' disable interrupts, polarity bit
Do
ready = DlPortReadPortUchar(baseAddr + 3) And 128
Loop Until ready = 0   'test for msb = 0 to signal NOT BUSY
                                       
                                       
lblStatus.Caption = "Reading Channel : " + Str(i)
DlPortWritePortUchar baseAddr + 2, (i * 8)    ' chan i, gain of 1

DlPortWritePortUchar baseAddr, 0  ' do dummy write to init A/D conversion

Do
ready = DlPortReadPortUchar(baseAddr + 3) And 128
Loop Until ready = 0   'test for msb = 0 to signal NOT BUSY

 low = DlPortReadPortUchar(baseAddr + 1)
high = DlPortReadPortUchar(baseAddr + 0)

signbit = (high And 128) / 256 ' 1=Positive numbers  0=Negative numbers

high = high And 127   ' take all but sign bit

reading = 256 * high + low
reading = reading * 5 / 32767

If signbit = False Then reading = -reading

lstResults.AddItem Str(reading)

lblResult(i).Caption = Str(reading)
lblStatus.Caption = " Finished Channel : " + Str(i)

End Sub

Private Sub Form_Load()
baseAddr = Val(txtAddr.Text)
Timer1.Interval = 67    ' don't read faster than once per 67 msec = 15 per second
Timer1.Enabled = False
End Sub

Private Sub Timer1_Timer()

Read_ADC16 (i)
i = i + 1    'inc channel
If i > 7 Then lstResults.Clear  ' display 0 through 7
If i > 7 Then i = 0             ' don't sample from greater than chan 7

End Sub
